<?php
require __DIR__ . '/config.php';
require __DIR__ . '/helpers.php';
header('Content-Type: application/json');

$all = read_json(DATA_DIR.'/vehicles.json', []);
$make=$_GET['make']??''; $minPrice=$_GET['minPrice']??null; $maxPrice=$_GET['maxPrice']??null;
$minYear=$_GET['minYear']??null; $maxYear=$_GET['maxYear']??null;
$q=isset($_GET['q'])?mb_strtolower(trim($_GET['q'])):'';

$filtered=array_values(array_filter($all,function($v)use($make,$minPrice,$maxPrice,$minYear,$maxYear,$q){
 if($make && strcasecmp($v['make'],$make)!==0)return false;
 if($minPrice!==null && ($v['price']??INF)<$minPrice)return false;
 if($maxPrice!==null && ($v['price']??-INF)>$maxPrice)return false;
 if($minYear!==null && ($v['year']??0)<$minYear)return false;
 if($maxYear!==null && ($v['year']??9999)>$maxYear)return false;
 if($q){$hay=mb_strtolower(($v['make'].' '.$v['model'].' '.$v['variant'].' '.$v['description']));if(mb_strpos($hay,$q)===false)return false;}
 return true;
}));

$perPage=max(1,(int)($_GET['perPage']??PAGE_SIZE_DEFAULT));
$page=max(1,(int)($_GET['page']??1)); $total=count($filtered);
$pages=max(1,(int)ceil($total/$perPage)); $page=min($page,$pages);
$offset=($page-1)*$perPage; $items=array_slice($filtered,$offset,$perPage);

function compute_meta($items){$makes=[];$years=[];$prices=[];foreach($items as $it){if($it['make'])$makes[$it['make']]=true;if($it['year'])$years[]=(int)$it['year'];if($it['price'])$prices[]=(float)$it['price'];}sort($years);sort($prices);ksort($makes);return['makes'=>array_keys($makes),'yearMin'=>$years?min($years):null,'yearMax'=>$years?max($years):null,'priceMin'=>$prices?floor(min($prices)):null,'priceMax'=>$prices?ceil(max($prices)):null];}

$meta=compute_meta($all);
echo json_encode(['success'=>true,'page'=>$page,'perPage'=>$perPage,'total'=>$total,'pages'=>$pages,'meta'=>$meta,'items'=>$items],JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
?>