<?php
require __DIR__ . '/config.php';
require __DIR__ . '/helpers.php';
ensure_dirs();

header('Content-Type: application/json');

if (isset($_GET['key']) && $_GET['key'] !== SHARED_SECRET) {
  http_response_code(403);
  echo json_encode(['success'=>false,'error'=>'Forbidden']); exit;
}

$rows = fetch_autotrader_listings();
if (!$rows) {
  http_response_code(500);
  echo json_encode(['success'=>false,'error'=>'No data returned']); exit;
}

$newList = [];
foreach ($rows as $row) {
  $v = normalise_vehicle($row);
  if (!$v['id']) continue;
  $v['_hash'] = hash_vehicle($v);
  $v['slug']  = slugify(trim(($v['make']??'').' '.($v['model']??'').' '.($v['variant']??'').' '.($v['year']??'')));
  $newList[$v['id']] = $v;
}

$prevPath = DATA_DIR.'/vehicles.json';
$prev = read_json($prevPath, []);
$prevById = [];
foreach ($prev as $p) $prevById[$p['id']] = $p;

$added=$removed=$updated=[];
foreach ($newList as $id=>$v) {
  if (!isset($prevById[$id])) $added[]=$v;
  else if (($prevById[$id]['_hash']??'')!==$v['_hash']) $updated[]=['before'=>$prevById[$id],'after'=>$v];
}
foreach ($prevById as $id=>$v) if (!isset($newList[$id])) $removed[]=$v;

write_json(DATA_DIR.'/vehicles.prev.json', array_values($prevById));
write_json(DATA_DIR.'/vehicles.json', array_values($newList));
$diff=['generatedAt'=>date('c'),'addedCount'=>count($added),'removedCount'=>count($removed),'updatedCount'=>count($updated),'added'=>$added,'removed'=>$removed,'updated'=>$updated];
write_json(DATA_DIR.'/latest-diff.json',$diff);

echo json_encode(['success'=>true,'summary'=>['total'=>count($newList),'added'=>count($added),'removed'=>count($removed),'updated'=>count($updated)]]);
?>